<?php

/***************************************************************************/
/*
/* 	----------------------------------------------------------------------
/* 						DO NOT EDIT THIS FILE
/*	----------------------------------------------------------------------
/* 
/*  			Built by Darcy Clarke. http://themify.me
/*  				Copyright (C) 2010 Themify
/*
/***************************************************************************/
/*  Nav
/***************************************************************************/	
	
	///////////////////////////////////////////
	// Create Nav Options
	///////////////////////////////////////////
	function themify_admin_nav() {
		global $theme;		
		add_menu_page('themify', $theme['Name'], 'manage_options', 'themify', 'themify_page', get_template_directory_uri().'/themify/img/favicon.png', 50);
		add_submenu_page('themify', $theme['Name'], 'تنظیمات', 'manage_options', 'themify', 'themify_page');
		add_submenu_page('themify', $theme['Name'], 'مستندات', 'manage_options', 'themify_docs', 'themify_docs');
	}

/*  Pages
/***************************************************************************/	
	
	///////////////////////////////////////////
	// Themify Documentation
	///////////////////////////////////////////
	function themify_docs(){
		echo "<script type='text/javascript'>window.location='http://themify.me/docs';</script>";
	}
	
	///////////////////////////////////////////
	// Themify Page
	///////////////////////////////////////////
	function themify_page() {
		
		if ( ! current_user_can( 'manage_options' ) )
			wp_die( __( 'You do not have sufficient permissions to update this site.', 'themify' ) );
		
		if (isset($_GET['action'])) {
			$action = 'upgrade';
			themify_updater();
		}
		
		global $data, $theme, $config, $version, $notifications;
		
		?>
        
        <!-- js -->
		<script type='text/javascript'>
        	// Themify Directory and Full Path
        	var app_url = "<?php echo get_template_directory_uri(); ?>/themify/";
        	var theme_url = "<?php echo get_template_directory_uri(); ?>/";
        	var blog_url = "<?php echo site_url(); ?>/";
        	var complete_status = true;
        	var current_obj = "";
        </script>       
        <!-- /js -->
        
        <!-- alerts -->
        <div class="alert"></div> 
        <!-- /alerts -->
        
        <!-- prompts -->
        <div class="prompt-box">
            <div class="show-login">
            	<form id="themify_update_form" method="post" action="admin.php?page=themify&action=upgrade&type=theme&login=true">
            	<p class="prompt-msg">Enter your Themify login info to upgrade</p>
	            <p><label>Username</label> <input type="text" name="username" class="username" value=""/></p>
	            <p><label>Password</label> <input type="password" name="password" class="password" value=""/></p>
	            <input type="hidden" value="theme" name="type" />
	            <input type="hidden" value="true" name="login" />
	            <p class="pushlabel"><input name="login" type="submit" value="Login" class="button upgrade-login" /></p>
	            </form>
            </div>
            <div class="show-error">
            	<p class="error-msg">There were some errors updating the theme</p>
            </div>
        </div>
        <div class="overlay">&nbsp;</div>
        <!-- /prompts -->
        
        <!-- html -->
        <form id="themify" method="post" action="" enctype="multipart/form-data">
        <p id="theme-title"><?php echo $theme['Name']; ?> <em><?php echo $theme['Version']; ?> (<a href="http://themify.me/logs/<?php echo strtolower($theme['Name']); ?>-changelogs" class="themify_changelogs" target="_blank">changelogs</a>)</em></p>
		<p class="top-save-btn"><a href="#" id="save-button" class="save-button">ذخیره همه</a></em></p>
		<div id="content">
        
            <!-- nav -->
            <ul id="maintabnav">
                <li class="setting"><a href="#setting">تنظیمات</a></li>
                <li class="styling"><a href="#styling">استایل</a></li>
                <li class="skins"><a href="#skins">پوسته ها</a></li>
                <li class="transfer"><a href="#transfer">انتقال</a></li>
            </ul>
            <!-- /nav -->
    		
            <!------------------------------------------------------------------------------------>
            
            <!--setting tab -->
            <div id="setting" class="maintab">
                
                <ul class="subtabnav">
                    <?php 
                    $x = 1;
                    foreach($config['panel']['settings']['tab'] as $tab){
                        if($x){
                            echo '<li class="selected"><a href="#setting-'.themify_scrub_func($tab['_a']['title']).'">'.$tab['_a']['title'].'</a></li>';	
                            $x = 0;
                        } else {
                            echo '<li><a href="#setting-'.themify_scrub_func($tab['_a']['title']).'">'.$tab['_a']['title'].'</a></li>';	
                        }
                    } 
                    ?>
                </ul>
                
                 <?php foreach($config['panel']['settings']['tab'] as $tab){ ?>					
                    <!-- subtab: setting-<?php echo themify_scrub_func($tab['_a']['title']); ?> -->
                    <div id="setting-<?php echo themify_scrub_func($tab['_a']['title']); ?>" class="subtab">
                        <?php 
						if(is_array($tab['_c']['custom-module'])){
							if(isset($tab['_c']['custom-module']['_a']['title']) && isset($tab['_c']['custom-module']['_a']['function'])){
								echo themify_fieldset($tab['_c']['custom-module']['_a']['title'], themify_scrub_func($tab['_c']['custom-module']['_a']['function']), $tab['_c']['custom-module']['_a']); 
							} else {
								foreach($tab['_c']['custom-module'] as $module){
									echo themify_fieldset($module['_a']['title'], themify_scrub_func($module['_a']['function']),$module['_a']); 
								}
							}
						}
                        ?>
                    </div>
                    <!-- /subtab: setting-<?php echo themify_scrub_func($tab['_a']['title']); ?> -->
                <?php } ?>
            
            </div>
            <!--/setting tab -->
            
            <!------------------------------------------------------------------------------------>
            
            <!--styling tab -->
            <div id="styling" class="maintab">
            
                <ul class="subtabnav">
                    <?php 
                    $x = 1;
					if(isset($config['panel']['styling']['tab']['_a']['title'])){
						echo '<li class="selected"><a href="#styling-'.themify_scrub_func($config['panel']['styling']['tab']['_a']['title']).'">'.$config['panel']['styling']['tab']['_a']['title'].'</a></li>';	
					} else {
						foreach($config['panel']['styling']['tab'] as $tab){
							if($x){
								echo '<li class="selected"><a href="#styling-'.themify_scrub_func($tab['_a']['title']).'">'.$tab['_a']['title'].'</a></li>';	
								$x = 0;
							} else {
								echo '<li><a href="#styling-'.themify_scrub_func($tab['_a']['title']).'">'.$tab['_a']['title'].'</a></li>';	
							}
						}
					}
					?>
                </ul>
                
                <?php 
				if(isset($config['panel']['styling']['tab']['_a']['title'])){
				?>
					<!-- subtab: styling-<?php echo themify_scrub_func($config['panel']['styling']['tab']['_a']['title']); ?> -->
						<div id="styling-<?php echo themify_scrub_func($config['panel']['styling']['tab']['_a']['title']); ?>" class="subtab">
							<?php 
							if(is_array($config['panel']['styling']['tab']['_c']['element'])){
								if(isset($config['panel']['styling']['tab']['_c']['element']['_a']['title']) && isset($config['panel']['styling']['tab']['_c']['element']['_a']['selector'])){
									echo themify_container(themify_scrub_func($tab['_a']['title']), $config['panel']['styling']['tab']['_c']['element']); 
								} else {
									foreach($config['panel']['styling']['tab']['_c']['element'] as $element){
										echo themify_container(themify_scrub_func($config['panel']['styling']['tab']['_a']['title']), $element); 
									}
								}
							}
							?>
						</div>
						<!-- /subtab: styling-<?php echo themify_scrub_func($tab['_a']['title']); ?> -->
				<?php 
				} else {
					foreach($config['panel']['styling']['tab'] as $tab){ ?>					
						<!-- subtab: styling-<?php echo themify_scrub_func($tab['_a']['title']); ?> -->
						<div id="styling-<?php echo themify_scrub_func($tab['_a']['title']); ?>" class="subtab">
							<?php 
							if(is_array($tab['_c']['element'])){
								if(isset($tab['_c']['element']['_a']['title']) && isset($tab['_c']['element']['_a']['selector'])){
									echo themify_container(themify_scrub_func($tab['_a']['title']), $tab['_c']['element']); 
								} else {
									foreach($tab['_c']['element'] as $element){
										echo themify_container(themify_scrub_func($tab['_a']['title']), $element); 
									}
								}
							}
							?>
						</div>
						<!-- /subtab: styling-<?php echo themify_scrub_func($tab['_a']['title']); ?> -->
					<?php } 
				} 
				?>
                
            </div>
            <!--/styling tab -->
    
    		<!------------------------------------------------------------------------------------>
            
            <!--skins tab -->
            <div id="skins" class="maintab">
                <ul class="subtabnav">
                    <li class="selected"><a href="#setting-general">پوسته ها</a></li>
                </ul>
               
                <div id="load-load" class="subtab">
                    <?php echo themify_get_skins(); ?>
                </div>
                
            </div>
            <!--/skins tab -->
    		
            <!------------------------------------------------------------------------------------>
            
            <!--import tab -->
            <div id="transfer" class="maintab">
                
                <ul class="subtabnav">
                    <li><a href="#import-import">ایمپورت/اکسپورت</a></li>
                </ul>
                
                <div id="transfer-import" class="subtab">
                    <p class="biggest-transfer-btn">
                    <a href="#" class="import" id="download-import">وارد کردن</a> <em>or</em>
                    <a href="#" class="export" id="download-export">خارج کردن</a>
                	</p>
                </div>
            
            </div>
            <!--/import tab -->
            
            <!------------------------------------------------------------------------------------>
    
        </div>
        <!--/content -->
        
        <!-- footer -->
        <div id="bottomtab">
            <p id="logo"><span>Themify</span> v<?php echo $version; ?></p>
            <p class="reset">
                <strong>دوباره:</strong> 
                <a href="#" id="reset-setting" class="reset-button">تنظیمات</a><a href="#" id="reset-styling" class="reset-button">استایل</a>
            </p>
            <p class="btm-save-btn">
            	<a href="#" class="save-button">ذخیره همه</a>
       		</p>
        </div>
        <!--/footer -->
        
   		</form>
    	<div class="clearBoth"></div>
        <!-- /html -->
        
		<?php 
	}
	
	
/*  Utilities
/***************************************************************************/	
///////////////////////////////////////////
// Enqueue Scripts
///////////////////////////////////////////
/**
 * @author Elio Rivero
 * @since 1.1.1.0
 * @package themify
 */


	///////////////////////////////////////////
	// Get Skins
	///////////////////////////////////////////
	function themify_get_skins(){
		global $db, $config, $theme;
		$data = get_data();
		$output = '<input type="hidden" name="skin" value="'.$data['skin'].'">';
		if($data['skin'] == '' || !isset($data['skin'])){
			$output .= '<div class="skin-preview"><a href="#"><img src="'.get_template_directory_uri().'/themify/img/non-skin.gif" alt="skin" id="" class="selected" /></a><br />بدون پوسته</div>';
		} else {
			$output .= '<div class="skin-preview"><a href="#"><img src="'.get_template_directory_uri().'/themify/img/non-skin.gif" alt="skin" id="" /></a><br />بدون پوسته</div>';
		}
		// Open Styles Folder
		$dir = dirname(__FILE__).'/../skins';
		if(is_dir($dir)){
			if($handle = opendir($dir)){
				// Grab Folders
				while (false !== ($dirTwo = readdir($handle))){
					if($dirTwo != '.' && $dirTwo != '..'){
						// Check For Folder
						if(is_dir(str_replace('//','/',dirname(__FILE__).'/').'../skins/'.$dirTwo)){
							// Open Folders
							if($handleTwo = opendir(str_replace('//','/',dirname(__FILE__).'/').'../skins/'.$dirTwo)){
								// Grab Files
								while(false !== ($file = readdir($handleTwo))){
									$ext = substr(strrchr($file, '.'), 1); // File Extension
									//echo $file;
									if($file == 'style.css'){
										$info = themify_get_skin_info(str_replace('//','/',dirname(__FILE__).'/').'../skins/'.$dirTwo.'/'.$file);
										$fullpath = get_template_directory_uri().'/skins/'.$dirTwo.'/'.$file;
										if(is_file(str_replace('//','/',dirname(__FILE__).'/').'../skins/'.$dirTwo.'/screenshot.png')){
											$image = get_template_directory_uri().'/skins/'.$dirTwo.'/screenshot.png';
										} else {
											$image = get_template_directory_uri().'/themify/img/screenshot-na.png';	
										}
										if($fullpath == $data['skin']){
											$output .= '<div class="skin-preview"><a href="#"><img src="'.$image.'" alt="skin" class="selected" id="'.get_template_directory_uri().'/skins/'.$dirTwo.'/style.css" /></a><br />'.$info['Skin Name'].'</div>';
										} else {
											$output .= '<div class="skin-preview"><a href="#"><img src="'.$image.'" alt="skin" id="'.get_template_directory_uri().'/skins/'.$dirTwo.'/style.css" /></a><br />'.$info['Skin Name'].'</div>';
										}
									}
								}
								closedir($handleTwo);
							}
						}
					}
				}		
				closedir($handle);
			} 
		}
		return $output;
	}
	
	///////////////////////////////////////////
	// Get CSS
	///////////////////////////////////////////
	function themify_get_css(){
		$data = get_data();
		if($data['skin'] != ""){
			$output .= '<link href="'.$data['skin'].'" rel="stylesheet" type="text/css" />'."\n";
		}
		if(is_file(TEMPLATEPATH . "/custom_style.css")){
			$output .=  '<link href="'.get_template_directory_uri().'/custom_style.css" rel="stylesheet" type="text/css" />'."\n";
		}
		if(is_array($data)){
			foreach($data as $name => $value){	
				$array = explode('-',$name);
				$path = "";
				foreach($array as $part){
					$path .= "['$part']";
				}
				eval("\$config".$path." = \$value;");
			}
			if(is_array($config['styling'])){
				$output .= "<style type='text/css'>\n";
				foreach($config['styling'] as $nav => $value){
					foreach($value as $element => $val){
						$temp = "";
						foreach($val as $attribute => $v){
							$attribute = str_replace("_", "-", $attribute);
							if($v['value'] != '' && isset($v['value'])){
								switch($attribute){
									case "border":
										foreach($v['value'] as $key => $val){
											if($val == ''){
												if(strpos($key, "style") === false){
													if(strpos($key, "color") === false){
														$v['value'][$key] = 0;
													} else {
														$v['value'][$key] = '000000';
													}	
												} else {
													$v['value'][$key] = 'solid';
												}
											}
										}
										if($v['value']['checkbox']){
											$temp .= "border: ".$v['value']['same']."px ".$v['value']['same_style']." #".$v['value']['same_color'].";\n";
										} else {
											if($v['value']['top'] != '' && $v['value']['top_style'] != '' && $v['value']['top_color'] != ''){
												$temp .= "border-top: ".$v['value']['top']."px ".$v['value']['top_style']." #".$v['value']['top_color'].";\n";
											}
											if($v['value']['right'] != '' && $v['value']['right_style'] != '' && $v['value']['right_color'] != ''){
												$temp .= "border-right: ".$v['value']['right']."px ".$v['value']['right_style']." #".$v['value']['right_color'].";\n";
											}
											if($v['value']['bottom'] != '' && $v['value']['bottom_style'] != '' && $v['value']['bottom_color'] != ''){
											
												$temp .= "border-bottom: ".$v['value']['bottom']."px ".$v['value']['bottom_style']." #".$v['value']['bottom_color'].";\n";
											}
											if($v['value']['left'] != '' && $v['value']['left_style'] != '' && $v['value']['left_color'] != ''){
												$temp .= "border-left: ".$v['value']['left']."px ".$v['value']['left_style']." #".$v['value']['left_color'].";\n";
											}
										}
									break;
									case "background-position":
										if($v['value']['x'] != '' && $v['value']['y']){
											foreach($v['value'] as $key => $val){
												if($val == ''){
													$v['value'][$key] = 0;
												}
											}
											$temp .= $attribute.": ";
											$temp .= $v['value']['x']." ".$v['value']['y'].";\n";
										}
									break;
									case "padding":
										if($v['value']['checkbox']){
											$temp .= $attribute.": ";
											$temp .= $v['value']['same']."px".";\n";		
										} else {
											if($v['value']['top'] != '' || $v['value']['right'] != '' || $v['value']['bottom'] != '' || $v['value']['left'] != ''){
												if($v['value']['top'] != ''){
													$temp .= "padding-top: ".$v['value']['top']."px;\n";
												}
												if($v['value']['right'] != ''){
													$temp .= "padding-right: ".$v['value']['right']."px;\n";
												}
												if($v['value']['bottom'] != ''){
													$temp .= "padding-bottom: ".$v['value']['bottom']."px;\n";
												}
												if($v['value']['left'] != ''){
													$temp .= "padding-left: ".$v['value']['left']."px;\n";
												}
											}
										}
									break;
									case "margin":
										if($v['value']['checkbox']){
											$temp .= $attribute.": ";
											$temp .= $v['value']['same']."px".";\n";		
										} else {
											if($v['value']['top'] != '' || $v['value']['right'] != '' || $v['value']['bottom'] != '' || $v['value']['left'] != ''){
												if($v['value']['top'] != ''){
													$temp .= "margin-top: ".$v['value']['top']."px;\n";
												}
												if($v['value']['right'] != ''){
													$temp .= "margin-right: ".$v['value']['right']."px;\n";
												}
												if($v['value']['bottom'] != ''){
													$temp .= "margin-bottom: ".$v['value']['bottom']."px;\n";
												}
												if($v['value']['left'] != ''){
													$temp .= "margin-left: ".$v['value']['left']."px;\n";
												}
											}
										}
									break;
									case "color":
										if($v['value']['value'] != '' && $v['value']['value'] != ' '){
											$temp .= $attribute.": ";
											$temp .= "#".$v['value']['value'].";\n";
										}
									break;
									case "background-color":
										if($v['value']['transparent']){
											$temp .= $attribute.": transparent;\n";											
										} else {
											if($v['value']['value'] != '' && $v['value']['value'] != ' '){
												$temp .= $attribute.": ";
												$temp .= "#".$v['value']['value'].";\n";
											}
										}
									break;
									case "background-image":
										if($v['value']['value'] != '' && $v['value']['value'] != ' '){
											$temp .= $attribute.": ";
											$temp .= "url(".$v['value']['value'].")".";\n";
										} else if($v['value']['none'] == "on"){
											$temp .= $attribute.": ";
											$temp .= "none;\n";
										}
									break;
									case "background-repeat":
										if($v['value']['value'] != '' && $v['value']['value'] != ' '){
											$temp .= $attribute.": ";
											$temp .= $v['value']['value'].";\n";
										}
									break;
									case "font-family":
										if($v['value']['value'] != '' && $v['value']['value'] != ' '){
											$temp .= $attribute.": ";
											$temp .= $v['value']['value'].";\n";
										}
									break;
									case "line-height":
										if($v['value']['value'] != '' && $v['value']['value'] != ' '){
											$temp .= $attribute.": ";
											$temp .= $v['value']['value'].$v['value']['unit'].";\n";
										}
									break;
									case "position":
										if($v['value']['value'] != '' && $v['value']['value'] != ' '){
											$temp .= $attribute.": ";
											$temp .= $v['value']['value'].";\n";
											if($v['value']['value'] == 'absolute' || $v['value']['value'] == 'fixed'){
												if($v['value']['x_value'] != '' && $v['value']['x_value'] != ' '){
													$temp .= $v['value']['x'].": ".$v['value']['x_value']."px;\n";
												}
												if($v['value']['y_value'] != '' && $v['value']['y_value'] != ' '){
													$temp .= $v['value']['y'].": ".$v['value']['y_value']."px;\n";
												}
											}
										}
									break;
									default:
										if($v['value']['value'] != '' && $v['value']['value'] != ' '){
											$temp .= $attribute.": ";
											$temp .= $v['value']['value'];
											if(isset($v['value']['unit'])){
												$temp .= $v['value']['unit'];
											}
											$temp .= ";\n";
										}
									break;
								}
							}
						}	
						if($temp != '' && $temp != ' '){
							$output .= urldecode(themify_scrub_decode($element))." {\n";
							$output .= $temp;
							$output .= "}\n\n";
						}
					}
				}
				$output .= "</style>";
			}
		} else {
			$output = "<style type='text/css'>/* No Values in the Database */</style>";
		}
		echo "\n\n".$output;
	}
	
	///////////////////////////////////////////
	// Get Skin Info
	///////////////////////////////////////////
	function themify_get_skin_info($file){
		$fh = fopen($file, 'r');
		$data = fread($fh, filesize($file));
		$tempArray = explode("\n",themify_strip("/*", "*/", $data, 0));
		$array = array();
		foreach($tempArray as $line){
			$tempLine = explode(":", $line);
			$array[$tempLine[0]] = $tempLine[1];
		}
		fclose($fh);
		return $array;
	}
	
	///////////////////////////////////////////
	// Strip
	///////////////////////////////////////////
	function themify_strip($startTag, $endTag, $text, $pos){
		if(!is_integer($pos)){
			$pos = false;
			return false;
		}	
		$pos1 = strpos($text,$startTag,$pos);
		if(!is_integer($pos1)){
			$pos = false;
			return false;
		}
		$pos1 += strlen($startTag);
		$pos2 = strpos($text,$endTag,$pos1);
		if(!is_integer($pos2)){
			$pos = false;return false;
		}
		$res = substr($text,$pos1,$pos2-$pos1);
		$pos = $pos2 + strlen($endTag);
		return $res;
	} 
	
	///////////////////////////////////////////
	// Scrub Function
	///////////////////////////////////////////
	function themify_scrub_func($string=""){
		return str_replace(array(' ', '/', ','), array('_', '_', '-'), strtolower($string));
	}
	
	///////////////////////////////////////////
	// Scrub
	///////////////////////////////////////////
	function themify_scrub($string=""){
		return str_replace(array('#','-',' ','.',':',',','[',']','=','<','>'), array('_id_','_dash_','_space_','_class_','_colon_','_comma_','_opensquare_','_closesquare_','_equal_','_openbracket_','_closebracket_'), $string);
	}
	
	///////////////////////////////////////////
	// Scrub Decode
	///////////////////////////////////////////
	function themify_scrub_decode($string=""){
		return str_replace(array('_id_','_dash_','_space_','_class_','_colon_','_comma_','_opensquare_','_closesquare_','_equal_','_openbracket_','_closebracket_'), array('#','-',' ','.',':',',','[',']','=','<','>'), $string);
	}
	
	///////////////////////////////////////////
	// Create Settings Fieldset
	///////////////////////////////////////////
	function themify_fieldset($title="", $module="", $attr=""){
		global $config;
		$data = get_data();
		if(function_exists("themify_".trim($module))){
			$output = '	<fieldset><legend>'.$title.'</legend>';
			$output .=	call_user_func("themify_".trim($module), array("data"=>$data['setting'][$title],"attr"=>$attr));
			$output .= '</fieldset>';	
		} else if(function_exists(trim($module))){
			$output = '	<fieldset><legend>'.$title.'</legend>';
			$output .=	call_user_func(trim($module), array("data"=>$data['setting'][$title],"attr"=>$attr));
			$output .= '</fieldset>';	
		}
		return $output;
	}
	
	///////////////////////////////////////////
	// Create Styles Container
	///////////////////////////////////////////
	function themify_container($category="", $element=array()){
		$data = get_data();
		$temp = array();
		if(is_array($data)){
			foreach($data as $name => $value){
				$array = explode('-',$name);
				$path = "";
				foreach($array as $part){
					$path .= "['$part']";
				}
				eval("\$temp".$path." = \$value;");
			}
		}
		if($element){
			$output = '	<fieldset><legend>'.$element['_a']['title'].'</legend>';
			if(is_array($element['_c']['module'])){
				if(isset($element['_c']['module']['_a']['name'])){
					$title = themify_scrub($element['_a']['selector']);
					$attr = $element['_c']['module']['_a'];
					$module = trim(str_replace(array(' ','-','|'),array('','_','hr'),$element['_c']['module']['_a']['name']));
					$value = $temp['styling'][$category][$title][$module];
					if(function_exists("themify_".$module)){
						$output .=	call_user_func("themify_".$module, array('category' => $category, 'title' => $title, 'value' => $value, 'attr' => $attr));
					} else {
						if(function_exists($module)){
							$output .=	call_user_func($module, array('category' => $category, 'title' => $title, 'value' => $value, 'attr' => $attr));	
						}
					}
				} else {
					foreach($element['_c']['module'] as $module){
						$title = themify_scrub($element['_a']['selector']);
						$attr = $module['_a'];
						$module = trim(str_replace(array(' ','-','|'),array('','_','hr'),$module['_a']['name']));
						$value = $temp['styling'][$category][$title][$module];
						if(function_exists("themify_".$module)){
							$output .=	call_user_func("themify_".$module, array('category' => $category, 'title' => $title, 'value' => $value, 'attr' => $attr));
						} else {
							if(function_exists($module)){
								$output .=	call_user_func($module, array('category' => $category, 'title' => $title, 'value' => $value, 'attr' => $attr));	
							}
						}
					}
				}
			}
			$output .= '</fieldset>';	
			return $output;
		}
	}
	
	/******************************************************************************************/
	/*
	/*	XML 2 Array
	/*	Via: http://mysrc.blogspot.com/2007/02/php-xml-to-array-and-backwards.html
	/*
	/*	Note: 	I'm starting to hate this function, the output is completely useless
	/*			not to mention it's got a terrible fallback for single elements within
	/*			an array. Instead of leaving a 0 / 1 index it sets the parent arrays 
	/*			value equal to that single index. Causes string offset issue if using
	/*			loops / foreach statements. 
	/*			
	/*			I will be writing a new version of this themify_xml2array() for 2.0. For now
	/*			this has reaked havoc on the core. It's made development messy as ****. 
	/*			I'm definitely not happy with how this scaled but it was the best at the 
	/*			time and allowed me to worry about other things. I originally tested
	/*			a few other xml2array functions that also had drawbacks. Most notably the 
	/*			lack of support for node attributes.  
	/*
	/*			$array["darcy"]["_a"]["is"] = "frustrated";
	/*			foreach($array["darcy"]["_c"]["future_developers"] as $developer){
	/*				$developer["_a"]["is"] = "screwed";
	/*			}
	/*
	/*			Oh wait, if there's only one "future_developer" this code breaks.
	/*			BAH!! #fail
	/*
	/*****************************************************************************************/	

	///////////////////////////////////////////
	// XML 2 Array Function
	///////////////////////////////////////////
	function themify_xml2array(&$string) {
		$parser = xml_parser_create();
		xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
		xml_parse_into_struct($parser, $string, $vals, $index);
		xml_parser_free($parser);
		$mnary=array();
		$ary=&$mnary;
		foreach ($vals as $r) {
			$t=$r['tag'];
			if ($r['type']=='open') {
				if (isset($ary[$t])) {
					if (isset($ary[$t][0])) $ary[$t][]=array(); else $ary[$t]=array($ary[$t], array());
					$cv=&$ary[$t][count($ary[$t])-1];
				} else $cv=&$ary[$t];
				if (isset($r['attributes'])) {foreach ($r['attributes'] as $k=>$v) $cv['_a'][$k]=$v;}
				$cv['_c']=array();
				$cv['_c']['_p']=&$ary;
				$ary=&$cv['_c'];
			} elseif ($r['type']=='complete') {
				if (isset($ary[$t])) { // same as open
					if (isset($ary[$t][0])) $ary[$t][]=array(); else $ary[$t]=array($ary[$t], array());
					$cv=&$ary[$t][count($ary[$t])-1];
				} else $cv=&$ary[$t];
				if (isset($r['attributes'])) {foreach ($r['attributes'] as $k=>$v) $cv['_a'][$k]=$v;}
				$cv['_v']=(isset($r['value']) ? $r['value'] : '');
	
			} elseif ($r['type']=='close') {
				$ary=&$ary['_p'];
			}
		}    
		_themify_del_p($mnary);
		return $mnary;
	}
	
	///////////////////////////////////////////
	// _Internal: Remove recursion in result array
	///////////////////////////////////////////
	function _themify_del_p(&$ary) {
		foreach ($ary as $k=>$v) {
			if ($k==='_p') unset($ary[$k]);
			elseif (is_array($ary[$k])) _themify_del_p($ary[$k]);
		}
	}
	
	///////////////////////////////////////////
	// Array to XML
	///////////////////////////////////////////
	function themify_ary2xml($cary, $d=0, $forcetag='') {
		$res=array();
		foreach ($cary as $tag=>$r) {
			if (isset($r[0])) {
				$res[]=themify_ary2xml($r, $d, $tag);
			} else {
				if ($forcetag) $tag=$forcetag;
				$sp=str_repeat("\t", $d);
				$res[]="$sp<$tag";
				if (isset($r['_a'])) {foreach ($r['_a'] as $at=>$av) $res[]=" $at=\"$av\"";}
				$res[]=">".((isset($r['_c'])) ? "\n" : '');
				if (isset($r['_c'])) $res[]=themify_ary2xml($r['_c'], $d+1);
				elseif (isset($r['_v'])) $res[]=$r['_v'];
				$res[]=(isset($r['_c']) ? $sp : '')."</$tag>\n";
			}
			
		}
		return implode('', $res);
	}
	
	///////////////////////////////////////////
	// Insert element into array
	///////////////////////////////////////////
	function themify_ins2ary(&$ary, $element, $pos) {
		$ar1=array_slice($ary, 0, $pos); $ar1[]=$element;
		$ary=array_merge($ar1, array_slice($ary, $pos));
	}
	
	///////////////////////////////////////////
	// Upload and Resize Image Function
	///////////////////////////////////////////
	function themify_imageHandler($file, $new_file, $width, $height, $ext = null){
		$source_path = $file;
		list( $source_width, $source_height, $source_type ) = getimagesize( $source_path );
		if($ext != null){
			$ext = pathinfo($ext);	
			$ext = strtolower($ext['extension']);
			switch ( $ext ){
				case "gif":
				$source_gdim = imagecreatefromgif( $source_path );
				break;
				case "jpeg":
				$source_gdim = imagecreatefromjpeg( $source_path );
				break;
				case "jpg":
				$source_gdim = imagecreatefromjpeg( $source_path );
				break;
				case "png";
				$source_gdim = imagecreatefrompng( $source_path );
				break;
			}
		} else {
			switch ( $source_type ){
				case IMAGETYPE_GIF:
				$source_gdim = imagecreatefromgif( $source_path );
				break;
				case IMAGETYPE_JPEG:
				$source_gdim = imagecreatefromjpeg( $source_path );
				break;
				case IMAGETYPE_PNG:
				$source_gdim = imagecreatefrompng( $source_path );
				break;
			}
		}
		$source_aspect_ratio = $source_width / $source_height;
		$desired_aspect_ratio = $width / $height;
		if ( $source_aspect_ratio > $desired_aspect_ratio ){
			$temp_height = $height;
			$temp_width = ( int ) ( $height * $source_aspect_ratio );
		} else {
			$temp_width = $width;
			$temp_height = ( int ) ( $width / $source_aspect_ratio );
		}
		$temp_gdim = imagecreatetruecolor( $temp_width, $temp_height );
		imagecopyresampled(
			$temp_gdim,
			$source_gdim,
			0, 0,
			0, 0,
			$temp_width, $temp_height,
			$source_width, $source_height
		);
		$x0 = ( $temp_width - $width ) / 2;
		$y0 = ( $temp_height - $height ) / 2;
		$desired_gdim = imagecreatetruecolor( $width, $height );
			imagecopy(
			$desired_gdim,
			$temp_gdim,
			0, 0,
			$x0, $y0,
			$width, $height
		);
		imagejpeg( $desired_gdim, $new_file, 100 );
		imagedestroy( $source_gdim );
		imagedestroy( $temp_gdim );
	}
	
	///////////////////////////////////////////
	// Create ZIP Package
	///////////////////////////////////////////
	if(class_exists('ZipArchive')){
		function themify_create_zip($files = array(),$destination = "",$overwrite = false) {
			if(file_exists($destination) && !$overwrite) { return false; }
				$valid_files = array();
				if(is_array($files)) {
					foreach($files as $file) {
						if(file_exists($file)) {
							$valid_files[] = $file;
						}
					}
				}
				if(count($valid_files)) {
					$zip = new ZipArchive();
					if($zip->open($destination,$overwrite ? ZIPARCHIVE::OVERWRITE : ZIPARCHIVE::CREATE) !== true) {
					return false;
				}
				foreach($valid_files as $file) {
					$zip->addFile($file,str_replace(array("../","./"),array("",""),$file));
				}
				$zip->close();
				return file_exists($destination);
			} else {
				return false;
			}
		}
	}
	
	///////////////////////////////////////////
	// Extract ZIP Package
	///////////////////////////////////////////
	if(class_exists('ZipArchive')){
		function themify_unzip($src_file, $dest_dir=false, $create_zip_name_dir=true, $overwrite=true){
					if(function_exists("zip_open")){   
						if(!is_resource(zip_open($src_file))){ 
							$src_file=dirname($_SERVER["SCRIPT_FILENAME"])."/".$src_file; 
						}
						if (is_resource($zip = zip_open($src_file))){          
							$splitter = ($create_zip_name_dir === true) ? "." : "/";
							if ($dest_dir === false) $dest_dir = substr($src_file, 0, strrpos($src_file, $splitter))."/";
							themify_create_dirs($dest_dir);
							while ($zip_entry = zip_read($zip)){
								$pos_last_slash = strrpos(zip_entry_name($zip_entry), "/");
								if ($pos_last_slash !== false){
									themify_create_dirs($dest_dir.substr(zip_entry_name($zip_entry), 0, $pos_last_slash+1));
								}
								if (zip_entry_open($zip,$zip_entry,"r")){
									$file_name = $dest_dir.zip_entry_name($zip_entry);
									if ($overwrite === true || $overwrite === false && !is_file($file_name)){
										$fstream = zip_entry_read($zip_entry, zip_entry_filesize($zip_entry));           
										if(!is_dir($file_name))            
										file_put_contents($file_name, $fstream );
										
										if(file_exists($file_name)){
											chmod($file_name, 0777);
											//echo "<span style=\"color:#1da319;\">file saved: </span>".$file_name."<br />";
										} else {
											//echo "<span style=\"color:red;\">file not found: </span>".$file_name."<br />";
										}
									}
									zip_entry_close($zip_entry);
								}      
							}
							zip_close($zip);
						} else {
							//echo "No Zip Archive Found.";
							return false;
						}
						themify_chmodr($dest_dir, 0755);
						return true;
					} else {
						return false;
					}
				}
				
			 	function themify_extract_zip($file){		
					$zip = zip_open($file);
					$dir = "temp/";
					if(is_resource($zip)){
						while($zip_entry = zip_read($zip)) {
							// echo $dir.basename(zip_entry_name($zip_entry));
							$fp = fopen($dir.basename(zip_entry_name($zip_entry)), "w");
							if(zip_entry_open($zip, $zip_entry, "r")) {
								$buf = zip_entry_read($zip_entry, zip_entry_filesize($zip_entry));
								fwrite($fp,"$buf");
								zip_entry_close($zip_entry);
								fclose($fp);
							}
						}
						zip_close($zip);
					} else {
						echo zipFileErrMsg($zip);		
					}
					if(file_exists($dir."config.xml")){
						unlink("../config.xml");
						rename($dir."config.xml", "../config.xml");
					}
					if(file_exists($dir."custom_modules.php")){
						unlink("../custom_modules.php");
						rename($dir."custom_modules.php","../custom_modules.php");
					}
					if(file_exists($dir."custom_widgets.php")){
						unlink("../custom_widgets.php");
						rename($dir."custom_widgets.php","../custom_widgets.php");
					}
					if(file_exists($dir."data_export.txt")){
						$handler = fopen($dir."data_export.txt", "r");
						$data = fread($handler, filesize($dir."data_export.txt"));
						set_data(unserialize($data));
						fclose($handler);
					}
				}
	}

	///////////////////////////////////////////
	// Force Download
	///////////////////////////////////////////
	function themify_force_download($file){ 
		if((isset($file))&&(file_exists($file))){ 
		   header("Content-type: application/force-download"); 
		   header('Content-Disposition: inline; filename="' . $file . '"'); 
		   header("Content-Transfer-Encoding: Binary"); 
		   header("Content-length: ".filesize($file)); 
		   header('Content-Type: application/octet-stream'); 
		   header('Content-Disposition: attachment; filename="' . $file . '"'); 
		   readfile("$file"); 
		} else {
			return false;
		}	
	}
	
	///////////////////////////////////////////
	// Build Custom Write Panels
	///////////////////////////////////////////
	function themify_build_write_panels($args){
		global $themify_write_panels;
		if(is_array($args)){
			$themify_write_panels = $args;
			add_action('admin_menu', 'themify_create_meta_boxes');  
			add_action('save_post', 'themify_save_postdata');
		}
	}
	
	///////////////////////////////////////////
	// Call Custom Write Panel
	///////////////////////////////////////////
	function themify_create_meta_boxes() {  
		global $themify_write_panels, $theme_name;  
		if(function_exists('add_meta_box')){
			foreach($themify_write_panels as $args){
				if($args['pages'] != ''){
					$themify_meta_page = $args['pages'];
				} else {
					$themify_meta_page = 'post';	
				}
				if($args['name'] != ''){
					$themify_meta_name = $args['name'];	
				} else {
					$themify_meta_name = 'Themify Options';
				}
				$pages = explode(",", $themify_meta_page);
				foreach($pages as $page){
					add_meta_box( 'themify-meta-boxes', 'Themify Custom Panel', 'themify_meta_boxes', trim($page), 'normal', 'high' ); 
				}
			}
		}  
	}  
	
	///////////////////////////////////////////
	// Build Custom Write Panel 
	///////////////////////////////////////////
	function themify_meta_boxes() { 
		
		global $post, $themify_write_panels;

echo '<div id="themify-meta-box-tabs">';		
		echo '<ul class="ilc-htabs themify-tabs-heading">';
		foreach($themify_write_panels as $write_panel){
			if( (trim($write_panel['pages']) == 'post' && $_GET['post_type'] == '') || $_GET['post_type'] == trim($write_panel['pages']) )
			echo '<li><span><a id="'. sanitize_title($write_panel['name']) . 't" href="#'. sanitize_title($write_panel['name']) . '">' . $write_panel['name'] . '</a></span></li>';
		}
		echo '</ul>';
		echo '<div class="ilc-btabs themify-tabs-body">';
		foreach($themify_write_panels as $write_panel){
			
			$pages = explode(",", $write_panel['pages']);
			$check = false;
			
			foreach($pages as $page){
				if(get_post_type($post)){
					if(get_post_type($post) == $page){
						$check = true;	
					}
				} else {
					if((trim($page) == 'post' && $_GET['post_type'] == '') || $_GET['post_type'] == trim($page)){
						$check = true;	
					}
				}
			}
			
			if($check){
				
			?>
            <div id="<?php echo sanitize_title($write_panel['name']); ?>" class="ilc-tab themify_write_panel">
            
           
            
            <div class="inside">
            	
                <input type="hidden" name="themify_proper_save" value="true" />
				
                <script type='text/javascript'>
        	// Themify Directory and Full Path
        	var app_url = "<?php echo get_template_directory_uri(); ?>/themify/";
        	var theme_url = "<?php echo get_template_directory_uri(); ?>/";
        	var blog_url = "<?php echo site_url(); ?>/";
        	var complete_status = true;
        	var current_obj = "";
        </script> 
                
                
                <script type="text/javascript">
                    jQuery(function($){
                                  
                        var complete_status = false;
                        $(".themify_upload_image").click(function(e){
                            //$("#themify_upload_image").
                        });
                        
                        $(".themify_field .preview-icon").click(function(e){
                            e.preventDefault();
                            $(this).parent().find(".selected").removeClass("selected");
                            $(this).addClass("selected");
                            $(this).parent().find(".val").val($(this).find("img").attr("alt"));
                        });
                        
                        $(".themify_field .query_category_single, .themify_field .query_category").blur(function(e){
                            $(this).parent().find(".val").val($(this).val());
                        });
                        
                        <?php foreach($write_panel['options'] as $meta_box): ?>
                        <?php if($meta_box['type'] == "image"): ?>
                            $("#themify_upload_image_<?php echo $meta_box['name']; ?>").uploadify({
                                    "uploader": "<?php echo get_template_directory_uri(); ?>/themify/js/uploadify.swf",
                                    "script": "<?php echo get_template_directory_uri(); ?>/themify/themify-ajax.php?upload-wordpress=true",
                                    "folder": "uploads",
                                    "cancelImg": "",
                                    "height": "23",
                                    "width": "66",
                                    "method": "POST",
                                    "hideButton": true,
                                    "wmode": "transparent",
                                    "fileDesc": "Image Files",
                                    "fileExt": "*.jpg;*.jpeg;*.gif;*.png",
                                    "multi": true,
                                    "sizeLimit": 100 * 1024 * 1024,
                                    "auto": true
                                });
                                $("#themify_upload_image_<?php echo $meta_box['name']; ?>").bind({
                                    "uploadifySelect": function (a, b, c) {
                                        showAlert()
                                    },
                                    "uploadifyOpen": function (a, b, c) {},
                                    "uploadifyError": function (a, b, c, d) {},
                                    "uploadifyProgress": function (a, b, c, d) {},
                                    "uploadifyCancel": function (a, b, c, d) {
                                        hideAlert()
                                    },
                                    "uploadifyComplete": function (a, b, c, d, e) {
                                        d = d.replace("%uFEFF","");
                                        var f = $.trim(decodeURI(d));
                                    	var file = f.replace("%3A",":");
                                        f = f.replace("%3A",":");
                                                   f = f.replace("%3A",":");
                                        hideAlert();
                                        $(this).parent().parent().find(".themify_upload_field").val(f);
                                        $(this).parent().parent().parent().find(".themify_upload_preview").html("<img src=\'<?php echo get_template_directory_uri(); ?>/themify/img.php?w=40&h=40&src=" + f + "\' alt=\'" + f + "\' />").fadeIn(200);
                                    }
                                });
                            <?php endif; ?>
                            <?php endforeach; ?>
                            
                    function showAlert() {
                        $(".alert").addClass("busy").fadeIn(800)
                    }
                    function hideAlert() {
                        $(".alert").removeClass("busy").addClass("done").delay(800).fadeOut(800, function () {
                            $(this).removeClass("done")
                        })
                    }
                    
                });
                </script>
                    
                <!-- alerts -->
                <div class="alert"></div> 
                <!-- /alerts -->
                
                <?php foreach($write_panel['options'] as $meta_box): ?>
                    <?php $meta_value = get_post_meta($post->ID, $meta_box['name'], true); ?>
                    
                    <?php
					///////////////////////////////////////////
					// Image Template 
					///////////////////////////////////////////
					?>
                    <?php if($meta_box['type'] == 'image'){ ?>
        
                              <input type="hidden" name="<?php echo $meta_box['name']; ?>_noncename" id="<?php echo $meta_box['name']; ?>'_noncename" value="<?php echo wp_create_nonce( plugin_basename(__FILE__) ); ?>" />
                              <div class="themify_field_row clearfix">
                                                      
                                    <div class="themify_field_title"><?php echo $meta_box['title']; ?></div>
                                    
                                    <div class="themify_field">
                                        <input type="text" name="<?php echo $meta_box['name']; ?>" value="<?php echo $meta_value; ?>" size="55" class="themify_input_field themify_upload_field" />
                                        <span class="themify_upload_buttons">
                                             <a href="#" class="button button-highlighted">Upload</a>
                                             <a href="#" id="themify_upload_image_<?php echo $meta_box['name']; ?>" class="button button-highlighted">swf</a>
                                        </span><br />
                                        
                                        <span class="themify_field_description"><?php echo $meta_box['description']; ?></span>
                                    </div>
                                    
                                <?php if($meta_value != ""): ?>
                                    <div class="themify_upload_preview" style="display:block;"><?php themify_image('w=40&h=40&src='.$meta_value); ?></div>
                              <?php else: ?>
                                    <div class="themify_upload_preview"></div>
                              <?php endif; ?>
                              
                              </div><!--/themify_field_row -->
                        
                    <?php
					///////////////////////////////////////////
					// Dropdown Template 
					///////////////////////////////////////////
					?>
                    <?php } else if($meta_box['type'] == 'dropdown'){ ?>
                        
                            <input type="hidden" name="<?php echo $meta_box['name']; ?>_noncename" id="<?php echo $meta_box['name']; ?>'_noncename" value="<?php echo wp_create_nonce( plugin_basename(__FILE__) ); ?>" />
                                <div class="themify_field_row clearfix">
        
                                     <div class="themify_field_title"><?php echo $meta_box['title']; ?></div>
                                     
                                     <div class="themify_field">
                                        <select name="<?php echo $meta_box['name']; ?>">
                                    <?php foreach($meta_box['meta'] as $option): ?>
                                            <?php if($option['value'] == $meta_value){ $selected = "selected='selected'"; } else { $selected = ""; } ?>
                                             <option value="<?php echo $option['value']; ?>" <?php echo $selected; ?>><?php echo $option['name']; ?></option>
                                            <?php endforeach; ?>   
                                        </select>
                                        <span class="themify_field_description"><?php echo $meta_box['description']; ?></span>
                                    </div>
                                    
                              </div><!--/themify_field_row -->
                        
                    <?php
					///////////////////////////////////////////
					// Textbox Template 
					///////////////////////////////////////////
					?>
                    <?php } else if($meta_box['type'] == 'textbox'){ ?>
                        
                            <input type="hidden" name="<?php echo $meta_box['name']; ?>_noncename" id="<?php echo $meta_box['name']; ?>'_noncename" value="<?php echo wp_create_nonce( plugin_basename(__FILE__) ); ?>" />
                                <div class="themify_field_row clearfix">
        
                                    <div class="themify_field_title"><?php echo $meta_box['title']; ?></div>
        
                                    <div class="themify_field">
                                        <?php 
                                        if($meta_box['meta']['size'] != '' && $meta_box['meta']['size'] == 'small'){
                                            $class = "small";	
                                        } else {
                                            $class = "";
                                        }
                                        ?>
                                        <input type="text" name="<?php echo $meta_box['name']; ?>" value="<?php echo $meta_value; ?>" size="55" class="themify_input_field <?php echo $class; ?>" />
                                        <span class="themify_field_description"><?php echo $meta_box['description']; ?></span>
                                    </div>
        
                              </div><!--/themify_field_row -->
                        
                    <?php
					///////////////////////////////////////////
					// Checkbox Template 
					///////////////////////////////////////////
					?>
                    <?php } else if($meta_box['type'] == 'checkbox'){ ?>
                        
                            <input type="hidden" name="<?php echo $meta_box['name']; ?>_noncename" id="<?php echo $meta_box['name']; ?>'_noncename" value="<?php echo wp_create_nonce( plugin_basename(__FILE__) ); ?>" />
                              <div class="themify_field_row clearfix">
        
                                    <div class="themify_field_title"><?php echo $meta_box['title']; ?></div>
                                    <?php if($meta_value){ $checked = "checked='checked'"; } else { $checked = ""; } ?>
        
                                    <div class="themify_field">
                                        <input type="checkbox" name="<?php echo $meta_box['name']; ?>" <?php echo $checked; ?> class="" />
                                        <span class="themify_checkbox_description"><?php echo $meta_box['description']; ?></span>
                                    </div>
        
                              </div><!--/themify_field_row -->
        
                    <?php
					///////////////////////////////////////////
					// Layout Template 
					///////////////////////////////////////////
					?>
                    <?php } else if($meta_box['type'] == 'layout'){ ?>
                        
                        	<input type="hidden" name="<?php echo $meta_box['name']; ?>_noncename" id="<?php echo $meta_box['name']; ?>'_noncename" value="<?php echo wp_create_nonce( plugin_basename(__FILE__) ); ?>" />
                            
                                <div class="themify_field_row clearfix">    
                                    <div class="themify_field_title"><?php echo $meta_box['title']; ?></div>
                                    <div class="themify_field">
                                        <?php foreach($meta_box['meta'] as $options){ ?>
                                        	<?php 
											if(($meta_value == "" || !$meta_value || !isset($meta_value)) && $options['selected']){ 
                                            	$meta_value = $options['value'];
											}
											if($meta_value == $options['value']){ 
												$class = "selected";
											} else {
												$class = "";	
											}
											?>
                                            <a href="#" class="preview-icon <?php echo $class; ?>"><img src="<?php echo get_template_directory_uri()."/".$options['img']; ?>" alt="<?php echo $options['value']; ?>"  /></a>
                                        <?php } ?>
                                        <input type="hidden" name="<?php echo $meta_box['name']; ?>" value="<?php echo $meta_value; ?>" class="val" />
                                        <span class="themify_field_description"><?php echo $meta_box['description']; ?></span>
                                    </div>
                                </div>
                                    
                    <?php
					///////////////////////////////////////////
					// Query Posts Template 
					///////////////////////////////////////////
					?>
                    <?php } else if($meta_box['type'] == 'query_category'){ ?>
                                
                             <input type="hidden" name="<?php echo $meta_box['name']; ?>_noncename" id="<?php echo $meta_box['name']; ?>'_noncename" value="<?php echo wp_create_nonce( plugin_basename(__FILE__) ); ?>" />
                              
                                <div class="themify_field_row clearfix">    
                                    <div class="themify_field_title"><?php echo $meta_box['title']; ?></div>
                                    <div class="themify_field">
                                        <?php echo preg_replace('/>/', '><option></option>', wp_dropdown_categories(array("class"=>"query_category_single","show_option_all"=>"All Categories","hide_empty"=>0, "echo"=>0,"name"=>$meta_box['name'],"selected"=>$meta_value)), 1);
                                        ?> or 
                                        <input type="text" class="query_category" value="<?php echo $meta_value; ?>" />
                                        <input type="hidden" value="<?php echo $meta_value; ?>" name="<?php echo $meta_box['name']; ?>" class="val" />
                                        <span class="themify_field_description"><?php echo $meta_box['description']; ?></span>
                                    </div>
                                </div>
                    
                    <?php
					///////////////////////////////////////////
					// Sidebar Visibility Template 
					///////////////////////////////////////////
					?>
                    <?php } else if($meta_box['type'] == 'sidebar_visibility'){ ?>
                    
                    		<input type="hidden" name="<?php echo $meta_box['name']; ?>_noncename" id="<?php echo $meta_box['name']; ?>'_noncename" value="<?php echo wp_create_nonce( plugin_basename(__FILE__) ); ?>" />
                            
                                <div class="themify_field_row clearfix">    
                                    <div class="themify_field_title"><?php echo $meta_box['title']; ?></div>
                                    <div class="themify_field">
                                    <?php 
                                    $sidebars = get_option('sidebars_widgets');
									global $wp_registered_sidebars;
                                    foreach($sidebars as $sidebar => $val){
                                        if($sidebar != 'wp_inactive_widgets' && $sidebar != 'array_version' && strpos(strtolower($wp_registered_sidebars[$sidebar]['name']),'sidebar') !== false){ 
										$checked = "";
										if(get_post_meta($post->ID, $meta_box['name'], true) == "" || !get_post_meta($post->ID, $meta_box['name'], true)){
											$checked = "checked='checked'";
										} else {
											foreach($meta_value as $key => $val){
												if(str_replace("'","",$key) == $wp_registered_sidebars[$sidebar]['name']){
													$checked = "checked='checked'";
												}
											}
										}
										?>
                                        <input type="checkbox" name="<?php echo $meta_box['name']; ?>[<?php echo $wp_registered_sidebars[$sidebar]['name']; ?>]" class="" <?php echo $checked; ?> /> <?php echo $wp_registered_sidebars[$sidebar]['name']; ?><br />
                                    <?php		
                                        }
                                    }
                                    ?>
                                    <span class="themify_field_description"><?php echo $meta_box['description']; ?></span>
                                    </div>	
                                </div>
                            
                    <?php } ?>
                
                <?php endforeach; ?>
            </div>
            </div>
			<?php 
			}
		}
	echo '</div>';//end .ilc-btabs
echo '</div>';//end #themify-meta-box-tabs

echo '<script type="text/javascript">';
	echo 'jQuery(document).ready(function(){';
		echo 'if(jQuery(".ilc-htabs li").length > 1)';
			echo 'ilcTabs({ilctabs  : "#themify-meta-box-tabs"});';
		echo 'else{';
			echo 'jQuery(".ilc-tab").show();';
			echo 'jQuery(".ilc-htabs li").addClass("select");';
		echo '}';
	echo '});';
echo '</script>';

	}
	
	///////////////////////////////////////////
	// Save Custom Write Panel Data
	///////////////////////////////////////////
	function themify_save_postdata( $post_id ) {  
		global $post, $themify_write_panels;  
		if(isset($_POST['themify_proper_save']) && $_POST['themify_proper_save'] != '') {
			foreach($themify_write_panels as $write_panel){
				
				foreach($write_panel['options'] as $meta_box) {  
					if ( 'page' == $_POST['post_type'] ) {  
						if ( !current_user_can( 'edit_page', $post_id ))  
						return $post_id;  
					} else {  
						if ( !current_user_can( 'edit_post', $post_id ))  
						return $post_id;  
					}  
					$data = $_POST[$meta_box['name']];
					
					if(get_post_meta($post_id, $meta_box['name']) == "")  
					add_post_meta($post_id, $meta_box['name'], $data, true);  
					elseif($data != get_post_meta($post_id, $meta_box['name'], true))  
					update_post_meta($post_id, $meta_box['name'], $data); 
				}  
			}
		} else {
			return $post->ID;	
		}
	}   
	
	///////////////////////////////////////////
	// Image Helper - Echo Get Image
	///////////////////////////////////////////
	function themify_image($options){
		echo themify_get_image($options);
	}
	
	///////////////////////////////////////////
	// Image Helper - Return Get Image
	///////////////////////////////////////////
	function themify_get_image($args){
		global $post, $image_width, $image_height, $config, $post_query_category;
		$data = get_data();
		parse_str($args, $options);
		foreach($options as $key => $val){
			$$key = $val;	
		}
		if($alt == "" && in_the_loop()){
			$alt = get_the_title();
		}
		if($crop == false || $crop == 'false'){
			$crop = "";
		} else {
			$crop = "&amp;zc=1";
		}
		if($a != "" && isset($a)){
			$a = "&amp;a=".$a;
		} else {
			if($data['setting-img_settings_crop_option'] != "" && $data['setting-img_settings_crop_option'])
				$a = "&amp;a=".$data['setting-img_settings_crop_option'];
			else
				$a = "";
		}
		$check = false;
		if($q != "" && isset($q)){
			$q = "&amp;q=".$q;
		} else {
			if($data['setting-img_settings_quality'] != "" && $data['setting-img_settings_quality'])
				$q = "&amp;q=".$data['setting-img_settings_quality'];
			else
				$q = "";
		}
		//$ignore = (!$ignore || !isset($ignore) || $ignore == "") ? false : true;
		if($src == '' || !isset($src)){
			if($field_name != '' && isset($field_name) && in_the_loop()){
				$fields = explode(",", $field_name);
				foreach($fields as $field){
					$field = trim($field);
					if($field == "wp_thumb" && function_exists("has_post_thumbnail")){
						if(has_post_thumbnail() && !$check){
							$temp = themify_prep_image(get_the_post_thumbnail());
							$src = $temp['src'];
							$class .= " ".$temp['class'];
							if($alt == "" && $temp['alt'] != '' && isset($temp['alt'])){
								$alt = $temp['alt'];									 
							}
							$check = true;
						}
					} else {
						if(get_post_meta($post->ID, $field, true) != '' && get_post_meta($post->ID, $field, true) && !$check){
							$src = get_post_meta($post->ID, $field, true);
							$check = true;
						}
					}
				}
			} else {
				if(in_the_loop()){
					$fields = array("Feature Image", "feature_image", "Post Image", "post_image", "image");
					foreach($fields as $field){
						if(get_post_meta($post->ID, $field, true) != '' && !$check){
							$src = get_post_meta($post->ID, $field, true);
							$check = true;	
						}
					}
					if(function_exists("has_post_thumbnail")){
						if(has_post_thumbnail() && !$check){
							$temp = themify_prep_image(get_the_post_thumbnail());
							$src = $temp['src'];
							$class .= " ".$temp['class'];
							if($alt == "" && $temp['alt'] != '' && isset($temp['alt'])){
								$alt = $temp['alt'];									 
							}
							$check = true;
						}
					}
					if(!$check){
						$tags = array("img","embed","iframe");
						$content = get_the_content();
						foreach($tags as $tag){
							$count = substr_count($content, '<'.$tag);
							if($count >= 1 && !$check){
								$start = strpos($content, '<'.$tag, 0);
								$pos = substr($content, $start);
								$end = strpos($pos, '>');
								$temp = themify_prep_image(substr($pos, 0, $end+1));
								$ext = explode(".", $temp['src']);
								$ext = strtolower($ext[(count($ext)-1)]);
								if(strpos($temp['src'],".") && ($ext == "jpg" || $ext == "jpeg" || $ext == "gif" || $ext == "png")){
									$check = true;
									$src = $temp['src'];
									$class .= $temp['class'];
									if($alt = "" && $temp['alt'] != '' && isset($temp['alt'])){
										$alt = $temp['alt'];									 
									}
								}
							}
						}
					}
				}
			}
		}
		if(in_the_loop() && get_post_meta($post->ID, 'image_width', true) != '' && !$ignore){			
			if($post_query_category != "")
				$width = $w;
			else
				$width = get_post_meta($post->ID, 'image_width', true);
			
		} elseif($data["setting-".$setting."_width"] != '' && $setting != ''){
			$width = $data["setting-".$setting."_width"];
		} elseif($image_width != '' && isset($image_width) && !$ignore){
			$width = $image_width;
		} else {
			if($w != '' && isset($w)){
				$width = $w;	
			}
		}
		if(in_the_loop() && get_post_meta($post->ID, 'image_width', true) != '' && !$ignore){
			if($post_query_category != "")
				$height = $h;
			else
				$height = get_post_meta($post->ID, 'image_height', true);
			
		} elseif($data["setting-".$setting."_height"] != '' && $setting != ''){
			$height = $data["setting-".$setting."_height"];
		} elseif($image_height != '' && isset($image_height) && !$ignore){
			$height = $image_height;
		} else {
			if($data['setting-img_settings_vertical_crop_option'] == "no"){
				$height = "";
			}
			else{
				if($h != '' && isset($h)){
					$height = $h;	
				}
			}
			
		}
		if($class != ''){	
			$class = "class='".$class."'";
		}
		if($id != ''){
			$id = "id='".$id."'";
		}
		
		$p_height = (isset($height) && $height != '') ? "height='".$height."'" : "";
		$p_width = (isset($width) && $width != '') ? "width='".$width."'" : "";
		
		if($src != '' && $src && isset($src)){			
			if($data['setting-img_settings_use'] == '' || !$data['setting-img_settings_use']){					
				
				return stripslashes($before)."<img src='".get_bloginfo("template_directory")."/themify/img.php?src=".$src."&amp;w=".$width."&amp;h=".$height.$crop.$q.$a."' alt='".$alt."' ".$class." ".$id." $p_width $p_height />".stripslashes($after);
				
			} else {
				return stripslashes($before)."<img src='".$src."' alt='".$alt."' ".$class." ".$id." $p_width $p_height />".stripslashes($after);
			}
		}
	}
	
	///////////////////////////////////////////
	// Image Helper - Prep Image
	///////////////////////////////////////////
	function themify_prep_image($tag){
		preg_match_all('/(alt|title|src|class)=("[^"]*")/i', $tag, $image);
		foreach($image[0] as $attr){
			parse_str($attr, $tempAttr);
			foreach($tempAttr as $key => $val){
				$tempArray[$key] = str_replace(array('"',"'"),array('',''),$val);	
			}
		}
		$image = $tempArray;
		if(strpos($image['src'],"youtube.com") || strpos($image['src'], "vimeo.com")){
			$image['src'] = themify_video_image($image['src']);
		}
		return array("src"=>trim($image['src'],"\\"), "alt"=>$image['alt'], "title"=>$image['title']);
	}
	
	///////////////////////////////////////////
	// Check if file exists
	///////////////////////////////////////////
	function themify_check_remote_file($url){
		if(function_exists("curl_init")){
			$ch = curl_init(); 
			curl_setopt($ch, CURLOPT_URL,$url);
			curl_setopt($ch, CURLOPT_NOBODY, 1);
			curl_setopt($ch, CURLOPT_FAILONERROR, 1);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
			if(curl_exec($ch)!==FALSE){
				return true;
			} else {
				return false;
			}
		} else {
			return is_readable($url);
		}
	}

	///////////////////////////////////////////
	// Vimeo / Youtube Thumbnail grab
	///////////////////////////////////////////
	function themify_video_image($url){
		$image_url = parse_url($url);
		if($image_url['host'] == 'www.youtube.com' || $image_url['host'] == 'youtube.com'){
			parse_str($image_url['query'], $query);
			if(isset($query['v']) && $query['v'] != ""){
				$id = $query['v'];
			} else {
				$path = explode("/",$image_url['path']);
				$id = $path[count($path)-1];
			}
			return "http://img.youtube.com/vi/".$id."/hqdefault.jpg";				
		} else if($image_url['host'] == 'www.vimeo.com' || $image_url['host'] == 'vimeo.com' || $image_url['host'] == 'player.vimeo.com'){
			parse_str($image_url['query'], $query);
			if(isset($query['clip_id']) && $query['clip_id'] != ""){
				$id = $query['clip_id'];
			} else {
				$path = explode("/",$image_url['path']);
				$id = $path[(count($path)-1)];
			}
			if(function_exists("file_get_contents")){
				$hash = unserialize(file_get_contents("http://vimeo.com/api/v2/video/".$id.".php"));
				if(isset($hash[0]) && $hash[0] != ''){
					return $hash[0]["thumbnail_large"]; 
				}
			}
		}
	}
	
	///////////////////////////////////////////
	// Variable Checker
	///////////////////////////////////////////
	function themify_check($var){
		global $post;
		$data = get_data();
		if($data[$var] != '' && isset($data[$var]) && isset($data[$var])){
			return true;
		} else if(get_post_meta($post->ID, $var, true) != '' && get_post_meta($post->ID, $var, true)){
			return true;
		} else {
			return false;	
		}
	}
	
	///////////////////////////////////////////
	// Version Getter
	///////////////////////////////////////////
	function themify_get($var){
		global $post;
		$data = get_data();
		if($data[$var] != '' && isset($data[$var])){
			return $data[$var];
		} else if(get_post_meta($post->ID, $var, true) != ''){
			return get_post_meta($post->ID, $var, true);
		}
	}
		
	///////////////////////////////////////////
	// Themify Shortcodes
	///////////////////////////////////////////
	function themify_shortcode($atts, $content=null, $code=""){
		switch($code){
			case 'is_logged_in':
				if(is_user_logged_in()){
					return do_shortcode($content);
				}
			break;
			case 'is_guest':
				if(!is_user_logged_in()){
					return do_shortcode($content);
				}
			break;
			case 'button':
				extract( shortcode_atts( array(	'color' => "",
											   	'size' 	=> "",
												'style'	=> "",
												'link' 	=> "#",
												'target'=> "",
												'text'	=> ""
												), $atts ) );	
				if($color != ''){
					$color = "background: $color;";
				}
				if($text != ''){
					$text = "color: $text;";	
				}
				return '<a href="'.$link.'" class="shortcode button '.$style.' '.$size.'" style="'.$color.$text.'" target="'.$target.'">'.do_shortcode($content).'</a>';
			break;
			case 'quote':
				return '<blockquote class="shortcode quote">'.do_shortcode($content).'</blockquote>';
			break;
			case 'col':
				extract( shortcode_atts( array( 'grid' => ""), $atts));
				return "<div class='shortcode col".$grid."'>".do_shortcode($content)."</div>";
			break;
			case 'img':
				extract( shortcode_atts( array(	'class' => "",
												'src' 	=> "",
												'id'	=> "",
												'h'		=> "",
												'w'		=> "",
												'crop'	=> true
												), $atts ) );	
				return themify_get_image("class=$class&src=$src&id=$id&h=$h&w=$w&crop=$crop");
			break;
			case 'hr':
				extract( shortcode_atts( array( 'color' => ""), $atts));
				return '<hr class="shortcode hr '.$color.'" />';
			break;
			case 'map':
				extract( shortcode_atts( array( 'address' => '99 Blue Jays Way, Toronto, Ontario, Canada', 'width' => "500px", 'height' => "300px", 'zoom' => 15), $atts));
				$num = rand(0,10000);
				return '<script type="text/javascript">	
  						  jQuery(function($){
						  	initialize("'.$address.'",'.$num.','.$zoom.');
						  });
						</script>
						<div class="shortcode map"><div id="themify_map_canvas_'.$num.'" style="display: block;width:'.$width.';height:'.$height.';" class="map-container">&nbsp;</div></div>';
			break;
			case 'video':
				extract( shortcode_atts( array(	'width' => "500px", 
												'height' => "300px", 
												'src' => "#"), $atts));
				$num = rand(0,10000);
				return '<div class="shortcode video"><a href="'.$src.'" style="display:block;width:'.$width.';height:'.$height.'" id="themify_player_'.$num.'"></a></div><script type="text/javascript">flowplayer("themify_player_'.$num.'", "'.get_template_directory_uri().'/themify/js/flowplayer-3.2.5.swf", { clip: { autoPlay:false } });</script>';
			break;
		}
	}
	///////////////////////////////////////////
    // Themify Get Content
    ///////////////////////////////////////////
	function themify_get_content($more_link_text = '(more...)', $stripteaser = 0, $more_file = '')
	{
		$content = get_the_content($more_link_text, $stripteaser, $more_file);
		$content = apply_filters('the_content', $content);
		$content = str_replace(']]>', ']]&gt;', $content);
		return $content;
	}
	///////////////////////////////////////////
    // Themify Excerpt
    ///////////////////////////////////////////	
	function themify_excerpt($limit) {
		$excerpt = explode(' ', get_the_excerpt(), $limit);
		if (count($excerpt)>=$limit) {
			array_pop($excerpt);
			$excerpt = implode(" ",$excerpt).'...';
		} else {
			$excerpt = implode(" ",$excerpt);
		}
			$excerpt = preg_replace('`[[^]]*]`','',$excerpt);
		return $excerpt;
	}
	///////////////////////////////////////////
    // Themify List Posts
    ///////////////////////////////////////////	
	function themify_shortcode_list_posts($atts, $content = null)
	{
		extract(shortcode_atts(array(
			'title' => 'yes',
			'category' => '0',
			'limit' => '5',
			'more_text' => 'More...',
			'excerpt_length' => '',
			'image' => 'no',
			'image_w' => '220',
			'image_h' => '150',
			'display' => 'none',
			'style' => 'list-post',
			'post_date' => 'no',
			'post_meta' => 'no'
		), $atts));
		global $wpdb, $post, $table_prefix;
		if ($category == 0) {
			$posts = get_posts(array(
				'numberposts' => $limit
			));
		} //$category == 0
		else {
			$arraycat = array($category);
			$listcat = $category;
			$arraycat = explode(',', $listcat);
			$posts    = get_posts('category='.$listcat.'&numberposts='.$limit);
			
		}
		if ($posts) {
			$customlistpoststr = '<!-- shortcode list_posts --> <div class="shortcode clearfix list-posts layout ' . $style . ' ">';
			foreach ($posts as $post):
				setup_postdata($post);
				global $more;
				$more = 0;
				$post_class = "";
				foreach(get_post_class() as $postclass)
				{
					$post_class .= " ".$postclass;
				}
				$customlistpoststr .= '<div class="post clearfix ' . $post_class . '">'; 
				if ($image == "yes") {
				
					$customlistpoststr .= themify_get_image('ignore=true&w='.$image_w.'&h='.$image_h.'&alt='.get_the_title().'&before=<p class="post-image"><a href="' . get_permalink() . '">&after=</a></p>');
				} //$image == "yes"
				$customlistpoststr .= '<div class="post-content">';
				if ($post_date == "yes") {
					$customlistpoststr .= '<p class="post-date">' . get_the_date() . '</p>';
				} //$post_date == "yes"
				if($title == "yes")
				{
					$customlistpoststr .= '<h3 class="post-title"><a href="' . get_permalink() . '">' . get_the_title() . '</a></h3>';
				}
				if ($post_meta == "yes") {
					$customlistpoststr .= '<p class="post-meta">
					<span class="post-author">' . get_the_author() . '</span>
					<span class="post-category">' . get_the_category_list(', ') . '</span>';
					$num_comments = get_comments_number();
					if (comments_open()) {
						 ob_start();
						 comments_popup_link('0', '1', '%', 'comments-link', '');
						$write_comments = ob_get_contents();
						ob_clean(); 
					} //comments_open()
					else {
						$write_comments = __('');
					}
					$customlistpoststr .= '<span class="post-comment">' . $write_comments . '</span>';
					if( has_tag() )
					{
						$customlistpoststr .= '<span class="post-tag">' . get_the_tag_list('', ', ') . '</span>';
					}
				$customlistpoststr .= '</p>';	
				} //$post_meta == "yes"
				if ($display == "content") {
					$customlistpoststr .= themify_get_content($more_text);
				} //$display == "content"
				if ($display == "excerpt") {
					if($excerpt_length)
					{
						$customlistpoststr .= themify_excerpt($excerpt_length);
					}
					else
					{
						$customlistpoststr .= get_the_excerpt();
					}
					
				} //$display == "excerpt"
				$customlistpoststr .= '</div>
		</div>';
			endforeach;
			$customlistpoststr .= '</div>
							<!-- /shortcode list_posts -->';
		} //$posts
		wp_reset_query();
		return $customlistpoststr;
	}
	///////////////////////////////////////////
    // Themify Flickr
    ///////////////////////////////////////////	
	
	function themify_shortcode_flickr($atts, $content = null)
	{
		extract(shortcode_atts(array(
			'user' => '',
			'set' => '',
			'group' => '',
			'limit' => '8',
			'size' => 's',
			'display' => 'latest'
		), $atts));
		$flickrstr = "";
		if($user)
		{
			$flickrstr = '<!-- shortcode Flickr --> <div class="shortcode clearfix flickr"><script type="text/javascript" src="http://www.flickr.com/badge_code_v2.gne?count='.$limit.'&amp;display='.$display.'&amp;size='.$size.'&amp;layout=x&amp;source=user&amp;user='.$user.'"></script></div>';
		}
		
		if($set)
		{
			if($flickrstr == "")
			{
			$flickrstr = '<div class="shortcode clearfix flickr"><script type="text/javascript" src="http://www.flickr.com/badge_code_v2.gne?count='.$limit.'&amp;display='.$display.'&amp;size='.$size.'&amp;layout=x&amp;source=user_set&amp;set='.$set.'"></script></div>';
			}
		}
		if($group)
		{
			if($flickrstr == "")
			{
			$flickrstr = '<div class="shortcode clearfix flickr"><script type="text/javascript" src="http://www.flickr.com/badge_code_v2.gne?count='.$limit.'&amp;display='.$display.'&amp;size='.$size.'&amp;layout=x&amp;source=group&amp;group='.$group.'"></script></div> <!-- /shortcode Flickr -->';
			}
		}
		return $flickrstr;
	}
	///////////////////////////////////////////
    // Themify Slide
    ///////////////////////////////////////////	
	function themify_shortcode_slide($atts, $content = null)
	{
		extract(shortcode_atts(array(), $atts));
		$output = '<li><div class="slide-wrap">'.$content.'</div></li>';
		return $output;
	}

	///////////////////////////////////////////
    // Themify Shorcode JS
    ///////////////////////////////////////////	
	add_action('wp_enqueue_scripts', 'themify_shortcodes_js_css');
	function themify_shortcodes_js_css(){
		if(!themify_check('setting-slider_script')){
			define('THEMIFY_SHORTCODES_VERSION', '1.6');
			//Enqueue jCarousel script to create a slider
			wp_enqueue_script('themify-jcarousel-js', get_template_directory_uri(). '/themify/js/jcarousel.js', '', THEMIFY_SHORTCODES_VERSION, true);
		}
		if(!themify_check('setting-shortcode_css')){
			//Enqueue themify shortcode script
			wp_enqueue_script('themify-shortcodes-js', get_template_directory_uri(). '/themify/js/themify.shortcodes.js', array('jquery'), false, true );
			
			//Enqueue general shortcode styles
			wp_enqueue_style( 'themify-shortcodes', get_template_directory_uri() . '/themify/css/shortcodes.css');
		}
	}
	///////////////////////////////////////////
    // Themify Slider
    ///////////////////////////////////////////	
	function themify_shortcode_slider($atts, $content = null)
	{
		extract(shortcode_atts(array(
			'wrap' => 'no',
			'visible' => '1',
			'scroll' => '1',
			'auto' => '0',
			'speed' => 'normal',
			'slider_nav' => 'yes',
			'class' => ''
		), $atts));
		$numsldrtemp = rand(0, 10000);
		$content = do_shortcode(shortcode_unautop($content));
		$strsldr = "";
		if($wrap == "yes")
		{
			$wrapvar = "circular";
		}
		if($wrap == "no")
		{
			$wrapvar = "null";
		}
		$strsldr = '<!-- shortcode slider -->	<div id="slider-'.$numsldrtemp.'" class="shortcode clearfix slider '.$class.'">
		<ul class="slides">
		'.$content.'
		</ul>';
		if ($slider_nav == "yes") {
			$nextbutton = "<div>&raquo;</div>";
			$prevbutton = "<div>&laquo;</div>";
		} else {
			$nextbutton = "null";
			$prevbutton = "null";				
		} //$slider_nav == "yes"
		$strsldr .= '</div><script type="text/javascript">
			function carousel_callback_'.$numsldrtemp.'(carousel)
			{
				// Disable autoscrolling if the user clicks the prev or next button.
				carousel.buttonNext.bind("click", function() {
					carousel.startAuto(0);
				});
			
				carousel.buttonPrev.bind("click", function() {
					carousel.startAuto(0);
				});
			
				// Pause autoscrolling if the user moves with the cursor over the clip.
				carousel.clip.hover(function() {
					carousel.stopAuto();
				}, function() {
					carousel.startAuto();
				});
			}
			jQuery(document).ready(function($) {
			$("#slider-'.$numsldrtemp.'").jcarousel({
				wrap: "'.$wrapvar.'",
				auto: '.$auto.',
				visible: '.$visible.',
				scroll: '.$scroll.',
				animation: "'.$speed.'",
				initCallback: carousel_callback_'.$numsldrtemp.',
				buttonNextHTML: "'.$nextbutton.'",
				buttonPrevHTML: "'.$prevbutton.'",
				initCallback: carousel_callback_'.$numsldrtemp.'
			});
		});
		</script> <!-- /shortcode slider -->';
		return $strsldr;
	}
	///////////////////////////////////////////
    // Themify Post Slider
    ///////////////////////////////////////////	
	function themify_shortcode_post_slider($atts, $content = null)
	{
		extract(shortcode_atts(array(
			'visible' => '1',
			'scroll' => '1',
			'auto' => '0',
			'wrap' => 'no',
			'excerpt_length' => '20',
			'speed' => 'normal',
			'slider_nav' => 'yes',
			'limit' => '5',
			'category' => '',
			'image' => 'yes',
			'image_w' => '240px',
			'image_h' => '180px',
			'more_text' => 'More...',
			'title' => 'yes',
			'display' => 'none',
			'post_meta' => 'no',
			'post_date' => 'no',
			'width' => '',
			'height' => '',
			'class' => ''
		), $atts));
		if($wrap == "yes")
		{
			$wrapvar = "circular";
		}
		if($wrap == "no")
		{
			$wrapvar = "null";
		}
		$numsldr = rand(0, 10000);
		global $wpdb, $post, $table_prefix;
		if ($category == 0) {
			$posts = get_posts(array(
				'numberposts' => $limit
			));
		} //$category == 0
		else {
			$arraycat = array(
				$category
			);
			$listcat  = $category;
			$arraycat = explode(',', $listcat);
			$posts    = get_posts('category='.$listcat.'&numberposts='.$show);
	
		}
		
		if ($posts) {
			$postsliderstr = '<!-- shortcode post_slider --> <div id="post-slider-' . $numsldr . '" style="width: ' . $width . '; height: ' . $height . ';" class="shortcode clearfix post-slider ' . $class . '">
			<ul class="slides">';
			foreach ($posts as $post):
				setup_postdata($post);
				global $more;
				$more       = 0;
				$post_class = "";
				foreach (get_post_class() as $postclass) {
					$post_class .= " " . $postclass;
				} //get_post_class() as $postclass
				$postsliderstr .= '<li><div  class="slide-wrap ' . $post_class . '">';
				if ($image == "yes") {
					$postsliderstr .= themify_get_image('ignore=true&w=' . $image_w . '&h=' . $image_h . '&alt=' . get_the_title() . '&before=<p class="post-image"><a href="' . get_permalink() . '">&after=</a></p>');
				} //$image == "yes"
				if ($title == "yes") {
					$postsliderstr .= '<h3 class="post-title"><a href="' . get_permalink() . '">' . get_the_title() . '</a></h3>';
				} //$title == "yes"
				if ($post_date == "yes") {
					$postsliderstr .= '<p class="post-date">' . get_the_date() . '</p>';
				} //$post_date == "yes"
				if ($post_meta == "yes") {
					$postsliderstr .= '<p class="post-meta">
						<span class="post-author">' . get_the_author() . '</span>
						<span class="post-category">' . get_the_category_list(', ') . '</span>';
					$num_comments = get_comments_number();
					if (comments_open()) {
						ob_start();
						comments_popup_link('0', '1', '%', 'comments-link', '');
						$write_comments = ob_get_contents();
						ob_clean();
					} //comments_open()
					else {
						$write_comments = __('');
					}
					$postsliderstr .= '<span class="post-comment">' . $write_comments . '</span>';
					if( has_tag() )
					{
						$postsliderstr .= '<span class="post-tag">' . get_the_tag_list('', ', ') . '</span>';
					}
					$postsliderstr .= '</p>';
				} //$post_meta == "yes"
				if ($display == "content") {
					$postsliderstr .= '<div class="post-content">' . themify_get_content($more_text) . '</div></div></li>
	';
				} //$display == "content"
				if ($display == "excerpt") {
					
					$postsliderstr .= '<div class="post-content">' . themify_excerpt($excerpt_length) . '</div></div></li>
	';
			
				} //$display == "excerpt"
			endforeach;
			$postsliderstr .= '</ul>';
			if ($slider_nav == "yes") {
				$nextbutton = "<div>&raquo;</div>";
				$prevbutton = "<div>&laquo;</div>";
			} else {
				$nextbutton = "null";
				$prevbutton = "null";				
			} //$slider_nav == "yes"
			$postsliderstr .= '</div><script type="text/javascript">
				function carousel_callback_'.$numsldr.'(carousel)
				{
					// Disable autoscrolling if the user clicks the prev or next button.
					carousel.buttonNext.bind("click", function() {
						carousel.startAuto(0);
					});
				
					carousel.buttonPrev.bind("click", function() {
						carousel.startAuto(0);
					});
				
					// Pause autoscrolling if the user moves with the cursor over the clip.
					carousel.clip.hover(function() {
						carousel.stopAuto();
					}, function() {
						carousel.startAuto();
					});
				}
			jQuery(document).ready(function($) {
			$("#post-slider-'.$numsldr.'").jcarousel({
				wrap: "'.$wrapvar.'",
				auto: '.$auto.',
				visible: '.$visible.',
				scroll: '.$scroll.',
				animation: "'.$speed.'",
				buttonNextHTML: "'.$nextbutton.'",
				buttonPrevHTML: "'.$prevbutton.'",
				initCallback: carousel_callback_'.$numsldr.'
			});
			});
		</script> <!-- /shortcode post_slider -->';
		} //$posts
		wp_reset_query();
		return $postsliderstr;
	}
	///////////////////////////////////////////
    // Themify Author Box
    ///////////////////////////////////////////	
	function themify_shortcode_author_box($atts, $content = null)
	{
		extract(shortcode_atts(array(
			'avatar' => 'yes',
			'avatar_size' => '48',
			'style' => '',
			'author_link' => 'no'
		), $atts));
		$authorboxstr .= '<!-- shortcode author_box --> <div class="shortcode clearfix author-box '.$style.'">';
		if($avatar == "yes")
		{
			$authorboxstr .= '<p class="author-avatar">'.get_avatar( get_the_author_meta('user_email'), $avatar_size, '' ).'</p>';
		}
		if(get_the_author_meta('user_url'))
		{
			$authorboxstr .= '<div class="author-bio">
				<h4 class="author-name"><a href="'.get_the_author_meta('user_url').'">'.get_the_author_meta('first_name').' '.get_the_author_meta('last_name').'</a></h4>
			'.get_the_author_meta('description');
		}
		else
		{
			$authorboxstr .= '<div class="author-bio">
			<h4 class="author-name">'.get_the_author_meta('first_name').' '.get_the_author_meta('last_name').'</h4>
		'.get_the_author_meta('description');
		}
		if($author_link == "yes")
		{
			if(get_the_author_meta('user_url'))
			{
				$authorboxstr .= '<p class="author-link"><a href="'.get_the_author_meta('user_url').'">&rarr; '.get_the_author_meta('user_firstname').' '.get_the_author_meta('user_lastname').' </a></p>';
			}
			else
			{
				$authorboxstr .= '<p class="author-link">&rarr; '.get_the_author_meta('user_firstname').' '.get_the_author_meta('user_lastname').' </p>';
			}
		}
		$authorboxstr .= '</div>
		</div> <!-- /shortcode author_box -->';
		return $authorboxstr;
	}
	///////////////////////////////////////////
    // Themify Box
    ///////////////////////////////////////////	
	function themify_shortcode_box($atts, $content = null)
	{
		extract(shortcode_atts(array(
			'style' => ''
		), $atts));
		$boxstr = '<!-- shortcode box --> <div class="shortcode clearfix box '.$style.'">'.$content.'</div> <!-- /shortcode box -->';
		return $boxstr;
	}
	///////////////////////////////////////////
	// Themify Video
	///////////////////////////////////////////
	function themify_video(){
		if(!themify_check('setting-video_player_script'))
		{
			echo '<script type="text/javascript" src="'.get_template_directory_uri().'/themify/js/flowplayer-3.2.4.min.js"></script>';
		}
	}
	add_action('wp_head','themify_video');
	
	///////////////////////////////////////////
	// Themify Google Maps
	///////////////////////////////////////////
	function themify_map(){
		if(!themify_check('setting-google_map_script'))
		{
			echo '<script type="text/javascript"
					    src="http://maps.google.com/maps/api/js?sensor=false">
					</script>
					<script type="text/javascript">
					  function initialize(address, num, zoom) {
						var geo = new google.maps.Geocoder(),
						latlng = new google.maps.LatLng(-34.397, 150.644),
						myOptions = {
						 \'zoom\': zoom,
						 center: latlng,
						 mapTypeId: google.maps.MapTypeId.ROADMAP
					    },
					    map = new google.maps.Map(document.getElementById("themify_map_canvas_" + num), myOptions);
						
						geo.geocode( { \'address\': address}, function(results, status) {
						 if (status == google.maps.GeocoderStatus.OK) {
						   map.setCenter(results[0].geometry.location);
						   var marker = new google.maps.Marker({
							  map: map, 
							  position: results[0].geometry.location
						   });
						 } else {
						   // status
						 }
					    });
					  }
					  </script>';
		}
	}
	add_action('wp_head','themify_map');
	
	///////////////////////////////////////////
	// Bind Themify Shortcodes
	///////////////////////////////////////////
	add_shortcode('is_logged_in', 'themify_shortcode');
	add_shortcode('is_guest', 'themify_shortcode');
	add_shortcode('button', 'themify_shortcode');
	add_shortcode('quote', 'themify_shortcode');
	add_shortcode('col', 'themify_shortcode');
	add_shortcode('img', 'themify_shortcode');
	add_shortcode('hr', 'themify_shortcode');
	add_shortcode('map', 'themify_shortcode');
	add_shortcode('video', 'themify_shortcode');
	add_shortcode('list_posts', 'themify_shortcode_list_posts');
	add_shortcode('flickr', 'themify_shortcode_flickr');
	add_shortcode('box', 'themify_shortcode_box');
	add_shortcode('post_slider', 'themify_shortcode_post_slider');
	add_shortcode('slider', 'themify_shortcode_slider');
	add_shortcode('slide', 'themify_shortcode_slide');
	add_shortcode('author_box', 'themify_shortcode_author_box');
	
	///////////////////////////////////////
	// Fix empty auto paragraph in shortcodes
	///////////////////////////////////////
	add_filter('the_content', 'themify_fix_shortcode_empty_paragraph');
	add_filter('the_excerpt', 'themify_fix_shortcode_empty_paragraph');
	add_filter('widget_text', 'themify_fix_shortcode_empty_paragraph');
	function themify_fix_shortcode_empty_paragraph($content)
	{   
	   $array = array (
		  '<p>[' => '[', 
		  ']</p>' => ']', 
		  ']<br />' => ']'
	   );
	   $content = strtr($content, $array);
	   return $content;
	}

	///////////////////////////////////////
	// Enable shortcode in excerpt
	///////////////////////////////////////
	add_filter('the_excerpt', 'do_shortcode');	
	add_filter('the_excerpt', 'shortcode_unautop');	

	///////////////////////////////////////	
	// Enable shortcode in text widget
	///////////////////////////////////////
	add_filter('widget_text', 'do_shortcode');	
	add_filter( 'widget_text', 'shortcode_unautop');

	///////////////////////////////////////
	// Load theme languages
	///////////////////////////////////////
	load_theme_textdomain( 'themify', TEMPLATEPATH.'/languages' );

	///////////////////////////////////////
	// Page navigation
	///////////////////////////////////////
	function themify_pagenav($before = '', $after = '') {
		global $wpdb, $wp_query;
	
		$request = $wp_query->request;
		$posts_per_page = intval(get_query_var('posts_per_page'));
		$paged = intval(get_query_var('paged'));
		$numposts = $wp_query->found_posts;
		$max_page = $wp_query->max_num_pages;
	
		if(empty($paged) || $paged == 0) {
			$paged = 1;
		}
		$pages_to_show = 8;
		$pages_to_show_minus_1 = $pages_to_show-1;
		$half_page_start = floor($pages_to_show_minus_1/2);
		$half_page_end = ceil($pages_to_show_minus_1/2);
		$start_page = $paged - $half_page_start;
		if($start_page <= 0) {
			$start_page = 1;
		}
		$end_page = $paged + $half_page_end;
		if(($end_page - $start_page) != $pages_to_show_minus_1) {
			$end_page = $start_page + $pages_to_show_minus_1;
		}
		if($end_page > $max_page) {
			$start_page = $max_page - $pages_to_show_minus_1;
			$end_page = $max_page;
		}
		if($start_page <= 0) {
			$start_page = 1;
		}
	
		if ($max_page > 1) {
			echo $before.'<div class="pagenav clearfix">';
			if ($start_page >= 2 && $pages_to_show < $max_page) {
				$first_page_text = "&laquo;";
				echo '<a href="'.get_pagenum_link().'" title="'.$first_page_text.'" class="number">'.$first_page_text.'</a>';
			}
			//previous_posts_link('&lt;');
			for($i = $start_page; $i  <= $end_page; $i++) {
				if($i == $paged) {
					echo ' <span class="number current">'.$i.'</span> ';
				} else {
					echo ' <a href="'.get_pagenum_link($i).'" class="number">'.$i.'</a> ';
				}
			}
			//next_posts_link('&gt;');
			if ($end_page < $max_page) {
				$last_page_text = "&raquo;";
				echo '<a href="'.get_pagenum_link($max_page).'" title="'.$last_page_text.'" class="number">'.$last_page_text.'</a>';
			}
			echo '</div>'.$after;
		}
	}

	///////////////////////////////////////////
	// Create Recursive Directories
	///////////////////////////////////////////
	function themify_create_dirs($path){
		if (!is_dir($path)){
			$directory_path = "";
			$directories = explode("/",$path);
			array_pop($directories);
			foreach($directories as $directory){
				$directory_path .= $directory."/";
				if (!is_dir($directory_path)){
					mkdir($directory_path);
					chmod($directory_path, 0777);
				}
			}
		}
	}
	
	///////////////////////////////////////////
	// Get Remote File Size
	///////////////////////////////////////////
	function themify_remote_filesize($url, $user = "", $pw = "") { 
		$ch = curl_init($url); 
		curl_setopt($ch, CURLOPTHEADER, 1); 
		curl_setopt($ch, CURLOPTNOBODY, 1); 
		curl_setopt($ch, CURLOPTRETURNTRANSFER, 1);
		if (!empty($user) && !empty($pw)) { 
			$headers = array('Authorization: Basic ' . base64encode("$user:$pw")); 
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers); 
		}
		$head = curl_exec($ch); 
		curl_close($ch);
		$regex = '/Content-Length:\s([0-9].+?)\s/'; 
		$count = preg_match($regex, $head, $matches);
		return isset($matches[1]) ? $matches[1] : false; 
	}
	
	///////////////////////////////////////////
	// Recursive folder & file chmod change
	///////////////////////////////////////////
	function themify_chmodr($path, $filemode){ 
		if (!is_dir($path)) 
			return chmod($path, $filemode); 
		$dh = opendir($path); 
		while (($file = readdir($dh)) !== false) { 
			if($file != '.' && $file != '..') { 
				$fullpath = $path.'/'.$file; 
				if(is_link($fullpath)) 
					return FALSE; 
				elseif(!is_dir($fullpath) && !chmod($fullpath, $filemode)) 
						return FALSE; 
				elseif(!themify_chmodr($fullpath, $filemode)) 
					return FALSE; 
			} 
		} 
		closedir($dh); 
		if(chmod($path, $filemode)){ 
			return TRUE; 
		} else { 
			return FALSE; 
		}
	}
?>